<?php

require_once '../inc/inc.php';
crossDomain();
$upgrade_root = realpath('./upgrades/');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit();
}

$router = input('router');

$pathinfo = explode('/', trim($router, '/'));
if (isset($pathinfo[0])) {
    $controller = $pathinfo[0];
} else {
    $controller = 'index';
}
if (isset($pathinfo[1])) {
    $action = $pathinfo[1];
} else {
    $action = 'index';
}

$action = preg_replace_callback('/([-_]+([a-z]{1}))/i', function ($matches) {
    return strtoupper($matches[2]);
}, $action);
$classFile = '../controllers/' . $controller . '.php';

if (!file_exists($classFile)) {
    error('请求不存在', 404);
}

require_once $classFile;

try {
    $reflection = new ReflectionClass($controller);
} catch (ReflectionException $e) {
    error('请求不存在', 404);
}

if ($reflection->hasMethod($action)) {
    $action = $reflection->getMethod($action);
    $action->invoke(new $controller());
} else {
    error('请求不存在', 404);
}

