<?php
error_reporting(E_ALL ^ E_NOTICE);
ini_set('date.timezone', 'UTC');
ini_set('session.gc_maxlifetime', 3600);
set_time_limit(10);
session_start();

require_once "handler.php";
require_once 'arr.php';
require_once 'helper.php';
require_once 'db.php';
require_once 'device.php';
require_once 'socket.php';
require_once 'controller.php';


$database = __DIR__ . '/../database/pdu.db';

$db = new DB();
$db->open($database);

//'127.0.0.1'  '192.168.0.163'
$socketClient = new SocketClient('127.0.0.1', 8888);

$device = new Device($socketClient);


$result = $db->query('select * from pdu_names');

$config = [];
$config['device_name'] = [];

//PDU名称
if ($result) {
    foreach ($result as $item) {
        $config['device_name'][$item['addr']] = $item;
    }
}

$language = isset($_REQUEST['language']) ? $_REQUEST['language'] : 'en-US';

if (file_exists(__DIR__.'/../lang/' . $language . '.php')) {
    $lang = require __DIR__.'/../lang/' . $language . '.php';
} else {
    $lang = [];
}

$setRet = $db->query("select * from settings");
if ($setRet) {
    foreach ($setRet as $set)
    {
        if ($set['name'] === 'hard_id')
        {
            $devUid = $set['value'];
            break;
        }
    }
    
    if(substr($devUid,3,1) === '6')
    {
        $GLOBALS['Flag']['isExternPort4'] = true;
    
    }else
    {
        $GLOBALS['Flag']['isExternPort4'] = false;
    }
    if(substr($devUid,1,1) === '1')
    {
        $GLOBALS['Flag']['is3PH'] = true;
    
    }else
    {
        $GLOBALS['Flag']['is3PH'] = false;
    }
}







