<?php

function generate_uuid()
{
    $charId = md5(uniqid(rand(), true));
    $hyphen = chr(45);// "-"
    $uuid = substr($charId, 0, 8) . $hyphen
        . substr($charId, 8, 4) . $hyphen
        . substr($charId, 12, 4) . $hyphen
        . substr($charId, 16, 4) . $hyphen
        . substr($charId, 20, 12);
    return $uuid;
}

/**
 * 返回N位的二进制转十进制数字，其中二进制的每一位都是1
 * 传入 5 =》31=》返回 11111
 * @param $num  位数
 * @return float|int
 */
function num_bin2dec($num)
{
    $dec = pow(2, $num - 1);
    $bin = decbin($dec + $dec - 1);
    return bindec($bin);
}

/*
    数字转 映射位数组,
*/
function num_bin2decArr($num)
{
    $num2 = $num - 32;
    $dec = pow(2, $num2 - 1);
    $bin = decbin($dec + $dec - 1);
    return array(0xFFFFFFFF,bindec($bin));
}

/**
 * 讲十进制数字转化为二进制字符串数组，并且翻转，从右往左表示第0个
 * 用于解析设备每个端口的通电状态
 * 目前最大 32 位 4个字节
 * 传入 5 =》 转bin为101 =》[1,0,1,0,0....]
 * @param $dec
 * @return array
 */
function dec2bin_arr($dec)
{
    $bin = str_pad(decbin($dec), 32, 0, STR_PAD_LEFT);
    return array_reverse(str_split($bin));
}

/**
 * 将数组转化为二进制
 * 传入 [0,1,4] =>[000000000000000000001011]
 * @param $arr
 * @return string
 */
function arr2bin($arr)
{
    $bin = str_split(str_repeat('0', 24));
    foreach ($arr as $num) {
        $bin[$num] = 1;
    }
    return implode('', array_reverse($bin));
}

/**
 * 将数组转化为十进制数
 * 传入 [0,1,4] =>[000000000000000000001011]=> 19
 * 主要用户设置端口等数组存入数据库的时候，把端口的 index 数组 转化二进制，对应的index 为1 ，否则为 0 再转化为 十进制整形 *
 * arr2bin2dec 的逆函数
 * @param $arr
 * @return integer
 */
function arr2bin2dec($arr)
{
    $bin = arr2bin($arr);
    return bindec($bin);
}

/**
 * 将十进制数转化为十进制数组
 * 用于从数据库查询出整形数据 转化为 二进制字符串，每一位为1的 存入位数到数组  arr2bin2dec 的逆函数
 * 传入 19 =>[000000000000000000001011]=> [0,1,4]
 * @param $dec
 * @return array
 */
function dec2bin2arr($dec)
{
    $arr = dec2bin_arr($dec);
    $result = [];
    foreach ($arr as $k => $v) {
        if (intval($v) === 1) {
            array_push($result, $k);
        }
    }
    return $result;
}


function getPduName($addr)
{
    if (isset($_SESSION['pdu_name'][$addr]) && $_SESSION['pdu_name'][$addr]) {
        return $_SESSION['pdu_name'][$addr];
    }
    global $device;
    $result = $device->getPortName($addr);
    $_SESSION['pdu_name'][$addr] = $result['device_name'];
    return $result['device_name'];
//    $device = Arr::get(config('device_name'), $addr, []);
//    return Arr::get($device, 'name', 'PDU' . ($addr + 1));
}

function getPortName($addr, $port)
{
//    $device = Arr::get(config('device_name'), $addr, []);
//    return Arr::get($device, 'port_' . $port, '支路' . ($port + 1));
    if (isset($_SESSION['port_name'][$addr][$port]) && $_SESSION['port_name'][$addr][$port]) {
        return $_SESSION['port_name'][$addr][$port];
    }
    global $device;
    $result = $device->getPortName($addr, $port);
    if (isset($result['port_names'][0])) {
        $name =  $result['port_names'][0]['name'];
    }else{
        $name =  'port ' . $port;
    }
    $_SESSION['port_name'][$addr][$port] = $name;
    return $name;

}
function success($data, $extras = [])
{
    function formatNumber(&$data)
    {
        foreach ($data as &$val) {
            if (is_numeric($val)) {
                $val = doubleval($val);
            } else if (is_array($val)) {
                formatNumber($val);
            }
        }
    }

    function transDatetime($data)
    {
        foreach ($data as $key => $val) {
            if (in_array($key, ['created_at', 'updated_at', 'datetime'], true)) {
                $data[$key] = utc2local($val);
            } else if (is_array($val)) {
                $data[$key] = transDatetime($val);
            }
        }
        return $data;
    }

    if (is_array($data)) {
        formatNumber($data);
        $data = transDatetime($data);
    }
    $json = [
        'data' => $data
    ];
    if (!empty($extras)) {
        $json = array_merge($json, $extras);
    }
    header('Content-Type:application/json');
    echo json_encode($json, JSON_UNESCAPED_UNICODE);
    exit;
}

function successNoNumber($data, $extras = [])
{
    function transDatetime($data)
    {
        foreach ($data as $key => $val) {
            if (in_array($key, ['created_at', 'updated_at', 'datetime'], true)) {
                $data[$key] = utc2local($val);
            } else if (is_array($val)) {
                $data[$key] = transDatetime($val);
            }
        }
        return $data;
    }

    if (is_array($data)) {
        $data = transDatetime($data);
    }
    $json = [
        'data' => $data
    ];
    if (!empty($extras)) {
        $json = array_merge($json, $extras);
    }
    header('Content-Type:application/json');
    echo json_encode($json, JSON_UNESCAPED_UNICODE);
    exit;
}

function error($message = '', $status = 400)
{
    $http = [
        100 => "HTTP/1.1 100 Continue",
        101 => "HTTP/1.1 101 Switching Protocols",
        200 => "HTTP/1.1 200 OK",
        201 => "HTTP/1.1 201 Created",
        202 => "HTTP/1.1 202 Accepted",
        203 => "HTTP/1.1 203 Non-Authoritative Information",
        204 => "HTTP/1.1 204 No Content",
        205 => "HTTP/1.1 205 Reset Content",
        206 => "HTTP/1.1 206 Partial Content",
        300 => "HTTP/1.1 300 Multiple Choices",
        301 => "HTTP/1.1 301 Moved Permanently",
        302 => "HTTP/1.1 302 Found",
        303 => "HTTP/1.1 303 See Other",
        304 => "HTTP/1.1 304 Not Modified",
        305 => "HTTP/1.1 305 Use Proxy",
        307 => "HTTP/1.1 307 Temporary Redirect",
        400 => "HTTP/1.1 400 Bad Request",
        401 => "HTTP/1.1 401 Unauthorized",
        402 => "HTTP/1.1 402 Payment Required",
        403 => "HTTP/1.1 403 Forbidden",
        404 => "HTTP/1.1 404 Not Found",
        405 => "HTTP/1.1 405 Method Not Allowed",
        406 => "HTTP/1.1 406 Not Acceptable",
        407 => "HTTP/1.1 407 Proxy Authentication Required",
        408 => "HTTP/1.1 408 Request Time-out",
        409 => "HTTP/1.1 409 Conflict",
        410 => "HTTP/1.1 410 Gone",
        411 => "HTTP/1.1 411 Length Required",
        412 => "HTTP/1.1 412 Precondition Failed",
        413 => "HTTP/1.1 413 Request Entity Too Large",
        414 => "HTTP/1.1 414 Request-URI Too Large",
        415 => "HTTP/1.1 415 Unsupported Media Type",
        416 => "HTTP/1.1 416 Requested range not satisfiable",
        417 => "HTTP/1.1 417 Expectation Failed",
        500 => "HTTP/1.1 500 Internal Server Error",
        501 => "HTTP/1.1 501 Not Implemented",
        502 => "HTTP/1.1 502 Bad Gateway",
        503 => "HTTP/1.1 503 Service Unavailable",
        504 => "HTTP/1.1 504 Gateway Time-out"
    ];

    if (php_sapi_name() !== 'cli') {
        header('Content-Type:application/json');
        header($http[$status]);
    }
    exit(json_encode([
        'error' => [
            'message' => trans($message),
            'code' => $status
        ]
    ]));
}
function config($name, $val = null)
{
    global $config;
    if ($val === null) {
        return Arr::get($config, $name);
    } else {
        Arr::set($config, $name, $val);
    }
}

function value($value)
{
    return $value instanceof Closure ? $value() : $value;
}

function checkLogin()
{
    if (!isset($_SESSION['user'])) {
        header('Content-Type:application/json');
        header('HTTP/1.1 403 Forbidden');
        error('请登陆', 401);
    }

     global $db;
   
    $ip = ip();
    if ($db->count("select count(*) from blacklist where ip = '{$ip}'")) {
        error('该IP不允许登录', 401);
        $_SESSION['user'] = null;
        unset($_SESSION['user']);
    }

}
function getMeta($total, $pageSize = 20)
{
    $meta = [
        'meta' => [
            'current_page' => intval(input('page', 1)),
            'total' => intval($total),
            'per_page' => intval($pageSize)
        ]
    ];
    return $meta;
}

function getUser()
{
    global $db;
    if (isset($_SESSION['user'])) {
        $result = $db->query("select * from users where id = {$_SESSION['user']['id']} limit 0,1");
        if (!$result) {
            return null;
        }
        return $result[0];
    }
    return null;
}

function checkPermission($per)
{ 
    global $db;
    $user = getUser();
    if ($user['role'] == 'admin') {
        return;
    }
    $permissions = $db->query("select * from permissions where role = '{$user['role']}' and permission = '{$per}'");
    if (!$permissions) {
        error('无权限', 403);
    }
}
function dd($data)
{
    echo "<pre>";
    print_r($data);
    echo "</pre>";
    exit;
}

function input($key = null, $default = null)
{
    $payload = json_decode(file_get_contents('php://input'), true);
    if (!$payload) {
        $payload = [];
    }
    $data = array_merge($_GET, $_POST, $payload);
    if ($key === null) {
        return $data;
    }
    return Arr::get($data, $key, $default);
}

function crossDomain()
{
    header('Access-Control-Allow-Credentials:true');
    header("Access-Control-Allow-Origin:http://localhost:8081");
    header('Access-Control-Allow-Methods:*');
    header('Access-Control-Allow-Headers:x-requested-with, content-type,app-local,x-time-offset');
}

function ip()
{
    $cip = '';
    if (!empty($_SERVER["HTTP_CLIENT_IP"])) {
        $cip = $_SERVER["HTTP_CLIENT_IP"];
    } elseif (!empty($_SERVER["HTTP_X_FORWARDED_FOR"])) {
        $cip = $_SERVER["HTTP_X_FORWARDED_FOR"];
    } elseif (!empty($_SERVER["REMOTE_ADDR"])) {
        $cip = $_SERVER["REMOTE_ADDR"];
    }
    return $cip;
}

function data_get($target, $key, $default = null)
{
    if (is_null($key)) {
        return $target;
    }

    $key = is_array($key) ? $key : explode('.', $key);

    while (!is_null($segment = array_shift($key))) {
        if ($segment === '*') {
            if (!is_array($target)) {
                return value($default);
            }

            $result = [];

            foreach ($target as $item) {
                $result[] = data_get($item, $key);
            }

            return in_array('*', $key) ? Arr::collapse($result) : $result;
        }

        if (Arr::accessible($target) && Arr::exists($target, $segment)) {
            $target = $target[$segment];
        } elseif (is_object($target) && isset($target->{$segment})) {
            $target = $target->{$segment};
        } else {
            return value($default);
        }
    }

    return $target;
}

function is_email($value)
{
    $pattern = "/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,})$/";

    return !!preg_match($pattern, $value);
}

function is_ip($value)
{
    return !!preg_match("/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/", $value);
}

function local2utc($datetime)
{
    if (!$datetime) {
        return null;
    }
    return date('Y-m-d H:i:s', strtotime($datetime) + secondOffset());
}

function utc2local($datetime)
{

    if ($datetime === null) {
        return null;
    }
    return date('Y-m-d H:i:s', strtotime($datetime) - secondOffset());
}

function secondOffset()
{
    $offset = isset($_SESSION['time_offset']) ? intval($_SESSION['time_offset']) : -480;
    return $offset * 60;
}

function trans($key)
{
    global $lang;
    if (isset($lang[$key])) {
        return $lang[$key];
    } else {
        return $key;
    }
}

function datetime2arr($datetime, $withTime = false)
{
    $time = strtotime($datetime);
    $result = [
        'year' => intval(date('Y', $time)),
        'month' => intval(date('n', $time)),
        'day' => intval(date('j', $time)),
    ];
    if ($withTime) {
        $result['hour'] = intval(date('G', $time));
        $result['minute'] = intval(date('i', $time));
        $result['second'] = intval(date('s', $time));
    }
    return $result;
}