<?php
require_once 'helper.php';

register_shutdown_function(function () {
    $error = error_get_last();
    if ($error) {
        ob_clean();
        error('系统错误'. $error['message']);
    }
});
set_error_handler(function ($errno, $errstr,$file,$line) {
    if ($errstr) {
        ob_clean();
        error($errstr.$file.$line);
    }
},E_ALL ^ E_NOTICE);

set_exception_handler(function (Throwable $error) {
    ob_clean();
    error($error->getMessage());
});



