<?php

use Carbon\Carbon;

class tasks extends controller
{


    public function __construct()
    {
        parent::__construct();
        checkLogin();
        checkPermission('计划任务管理');
    }

    public function index()
    {
        checkLogin();
        $addr = input('addr', 0);
        $result = $this->device->queryTasks($addr, input('start_date'), input('end_date'). ' 23:59:59');
        $data = [];
        foreach ($result as $task) {
            $task['addr_name'] = getPduName($task['addr']);
            $task['ports_name'] = array_map(function ($port) use ($task) {
                return getPortName($task['addr'], $port);
            }, $task['ports']);
            $data[] = $task;
        }
        success($data, getMeta(count($data), 1000));
    }
//    public function _index()
//    {
//        checkLogin();
//        $where = '1=1 ';
//        $addr = input('addr', null);
//        if ($addr !== null) {
//            $where .= " and addr = " . intval($addr);
//        }
//        if (input('start_date')) {
//            $start_date = local2utc(input('start_date'));
//
//            $where .= " and date>= '{$start_date}'";
//        }
//        if (input('end_date')) {
//            $end_date = local2utc(date('Y-m-d H:i:s', strtotime(input('end_date')) + 3600 * 24 - 1));
//            $where .= " and date <= '{$end_date}'";
//        }
//
//        $result = $this->device->queryTasks($addr);
//
//        success($result);
//
//
//        $result = $this->db->paginate("select * from tasks where {$where} order by id desc");
//
//
//        $count = $this->db->count("select count(*) from tasks where {$where}");
//
//        foreach ($result as &$item) {
//            $item['ports'] = dec2bin2arr($item['ports']);
//            $item['repeat'] = dec2bin2arr($item['repeat']);
//            $item['date_time'] = utc2local($item['date'] . ' ' . $item['time']);
//            $item['addr_name'] = getPduName($item['addr']);
//            $item['ports_name'] = array_map(function ($port) use ($item) {
//                return getPortName($item['addr'], $port);
//            }, $item['ports']);
//
//            $utcWeekday = date('w', strtotime($item['date'] . ' ' . $item['time'])); //原始的星期
//            $localWeek = date('w', strtotime($item['date_time'])); //UTC的星期
//            $weeDiff = $localWeek - $utcWeekday;
//
//            //把每个星期加上差值
//            array_walk($item['repeat'], function (&$item) use ($weeDiff) {
//                $item += $weeDiff;
//                if ($item > 6) {
//                    $item = 0;
//                } else if ($item < 0) {
//                    $item = 6;
//                }
//            });
//        }
//        success($result, getMeta($count));
//    }

    public function show()
    {
        $id = intval(input('id'));
        $addr = intval(input('addr'));
        if (!$id) {
            error('参数错误');
        }
        $result = $this->device->queryTasks($addr);
        $task = null;
        foreach ($result as $item) {
            if ($item['id'] === $id) {
                $task = $item;
                break;
            }
        }
        if (!$task) {
            error('计划任务不存在');
        }


        success($task);
    }

//    public function show()
//    {
//        $id = intval(input('id'));
//        if (!$id) {
//            error('参数错误');
//        }
//        $task = $this->db->find("select * from tasks where id={$id}");
//
//        if (!$task) {
//            error('计划任务不存在');
//        }
//
//
//        $utcWeekday = date('w', strtotime($task['date'] . ' ' . $task['time'])); //原始的星期
//        $task['ports'] = dec2bin2arr($task['ports']);
//        $task['repeat'] = dec2bin2arr($task['repeat']);
//        $datetime = utc2local($task['date'] . ' ' . $task['time']);
//        $task['date'] = explode(' ', $datetime)[0];
//        $task['time'] = explode(' ', $datetime)[1];
//        $localWeek = date('w', strtotime($datetime)); //UTC的星期
//        $weeDiff = $localWeek - $utcWeekday;
//
//        //把每个星期加上差值
//        array_walk($task['repeat'], function (&$item) use ($weeDiff) {
//            $item += $weeDiff;
//            if ($item > 6) {
//                $item = 0;
//            } else if ($item < 0) {
//                $item = 6;
//            }
//        });
//        success($task);
//    }

//    public function save()
//    {
//        $addr = input('addr');
//        $ports = (array)input('ports');
//        $action = input('action');
//        $date = input('date');
//        $time = input('time');
//        $repeat = (array)input('repeat');
//        $remark = input('remark');
//        if (is_null($addr)) {
//            error('请选择PDU');
//        }
//        if (!$ports || count($ports) === 0) {
//            error('请选择端口');
//        }
//        if (!$date) {
//            error('请填写执行日期');
//        }
//        if (!$time) {
//            error('请填写执行时间');
//        }
//        $originWeekday = date('w', strtotime($date . ' ' . $time)); //原始的星期
//        $datetime = local2utc($date . ' ' . $time);
//        list($date, $time) = explode(' ', $datetime);
//        $utcWeekday = date('w', strtotime($datetime)); //转化之后的utc星期
//        $weeDiff = $utcWeekday - $originWeekday;
//
//        //把每个星期加上差值
//        array_walk($repeat, function (&$item) use ($weeDiff) {
//            $item += $weeDiff;
//            if ($item > 6) {
//                $item = 0;
//            } else if ($item < 0) {
//                $item = 6;
//            }
//        });
//
//        $ports = arr2bin2dec($ports);
//        $repeat = arr2bin2dec($repeat);
//        $sql = "insert into tasks (addr,ports,`action`,`date`,`time`,repeat,remark,created_at,updated_at) values({$addr},{$ports},{$action},'{$date}','{$time}',{$repeat},'{$remark}','{$this->datetime}','{$this->datetime}')";
//        $this->db->exec($sql);
//        $this->device->createTask($this->db->getLastId(), $addr);
//        $this->writeLog("创建了计划任务【id:{$this->db->getLastId()}】");
//        success($this->db->getLastId());
//    }
    public function save()
    {
        $addr = input('addr');
        $ports = (array)input('ports');
        $action = input('action');
        $date = input('date');
        $time = input('time');
        $repeat = (array)input('repeat');
        $remark = input('remark');
        if (is_null($addr)) {
            error('请选择PDU');
        }
        if (!$ports || count($ports) === 0) {
            error('请选择端口');
        }
        if (!$date) {
            error('请填写执行日期');
        }
        if (!$time) {
            error('请填写执行时间');
        }
        $this->device->addTask($addr, $ports, $action, $date . ' ' . $time, $repeat, $remark);
        $this->writeLog("创建了计划任务【id:{$this->db->getLastId()}】");
        success($this->db->getLastId());
    }

    public function update()
    {
        $id = input('id');
        $addr = input('addr');
        $ports = (array)input('ports');
        $action = input('action');
        $date = input('date');
        $time = input('time');
        $repeat = (array)input('repeat');
        $remark = input('remark');
        if (!$id) {
            error('参数错误');
        }
        if (is_null($addr)) {
            error('请选择PDU');
        }
        if (!$ports || count($ports) === 0) {
            error('请选择端口');
        }
        if (!$date) {
            error('请填写执行日期');
        }
        if (!$time) {
            error('请填写执行时间');
        }
        $this->device->editTask($id,$addr, $ports, $action, $date . ' ' . $time, $repeat, $remark);
        $this->writeLog("修改了计划任务【id:{$id}】");
        success([]);
    }

//    public function update()
//    {
//        $id = input('id');
//        $addr = input('addr');
//        $ports = (array)input('ports');
//        $action = input('action');
//        $date = input('date');
//        $time = input('time');
//        $repeat = (array)input('repeat');
//        $remark = input('remark');
//        if (!$id) {
//            error('参数错误');
//        }
//        if (is_null($addr)) {
//            error('请选择PDU');
//        }
//        if (!$ports || count($ports) === 0) {
//            error('请选择端口');
//        }
//        if (!$date) {
//            error('请填写执行日期');
//        }
//        if (!$time) {
//            error('请填写执行时间');
//        }
//
//        $originWeekday = date('w', strtotime($date . ' ' . $time)); //原始的星期
//        $datetime = local2utc($date . ' ' . $time);
//        list($date, $time) = explode(' ', $datetime);
//        $utcWeekday = date('w', strtotime($datetime)); //转化之后的utc星期
//        $weeDiff = $utcWeekday - $originWeekday;
//
//        //把每个星期加上差值
//        array_walk($repeat, function (&$item) use ($weeDiff) {
//            $item += $weeDiff;
//            if ($item > 6) {
//                $item = 0;
//            } else if ($item < 0) {
//                $item = 6;
//            }
//        });
//        $ports = arr2bin2dec($ports);
//        $repeat = arr2bin2dec($repeat);
//        $sql = "update tasks set addr = {$addr},ports = {$ports},action = {$action},`date` = '{$date}',`time` = '{$time}',repeat = {$repeat},remark = '{$remark}',updated_at = '{$this->datetime}' where id = {$id}";
//        $this->db->exec($sql);
//        $this->device->updateTask($id, $addr);
//        $this->writeLog("修改了计划任务【id:{$id}】");
//        success([]);
//    }

//    public function delete()
//    {
//        $id = input('id');
//        $task = $this->db->find("select * from tasks where id = {$id}");
//        if (!$task) {
//            error('计划任务不存在');
//        }
//        $this->db->exec("delete from tasks where id = {$id}");
//        $this->device->deleteTask($id, $task['addr']);
//        $this->writeLog("删除了计划任务【id:{$id}】");
//        success([]);
//    }

    public function delete()
    {
        $id = input('id');
        $addr = input('addr');
        $this->device->delTask($id, $addr);
        $this->writeLog("删除了计划任务【id:{$id}】");
        success([]);
    }

}
