<?php


class statistics extends controller
{

    protected $db2;

    public function __construct()
    {
        parent::__construct();
        checkLogin();
        checkPermission('统计');
        $database = __DIR__ . '/../database/energy.db';
        $this->db2 = new DB();
        $this->db2->open($database);
    }

    public function index_bak()
    {
        $addr = intval(input('addr', 0));
        $datetime = (array)input('datetime');

        $result = $this->db->query("select * from statistics where addr = " . $addr . " and (datetime between '" . local2utc($datetime[0]) . "' and '" . local2utc($datetime[1]) . "')");

        success($result);
    }

    public function index()
    {
        $port = input('port');
        $start_date = input('start_date');
        $end_date = input('end_date');
        $type = input('type');
        if ($type === 'hour') {
            $start_date = date('Y-m-d H:i:s', strtotime($start_date));
            $end_date = date('Y-m-d H:i:s', strtotime("$end_date +1 day -1 second"));
        } else if ($type == 'day') {
            $start_date = date('Y-m-d H:i:s', strtotime($start_date));
            $end_date = date('Y-m-d H:i:s', strtotime("$end_date +1 day -1 second"));
        } else if ($type == 'month') {
            $start_date = date('Y-m-d H:i:s', strtotime($start_date));
            $end_date = date('Y-m-d H:i:s', strtotime("$end_date +1 month -1 second"));
        }


        $sql = "select * from statistics where  (datetime between '" . local2utc($start_date) . "' and '" . local2utc($end_date) . "')";
        if ($port != "-1") {
	    $p = intval($port);
            $sql .= " and port = {$p}";
        } else {
            $sql .= " and port = 255";
        }
        $result = $this->db2->query($sql);

        $start_time = strtotime($start_date);
        $end_time = strtotime($end_date);
        switch ($type) {
            case 'day':
                $step = "+1 day";
                $format = 'Y-m-d';
                break;
            case "month":
                $step = "+1 month";
                $format = 'Y-m';
                break;
            case 'hour':
            default:
                $step = "+1 hour";
                $format = 'Y-m-d H:00';
                break;
        }

        foreach ($result as $k => $value) {
            $value['datetime'] = utc2local($value['datetime']);
            $result[$k]['date'] = date($format, strtotime($value['datetime']));
        }

        $newResult = [];
        $current_time = $start_time;
        while (true) {
            if ($current_time > $end_time) {
                break;
            }
            $key = date($format, $current_time);
            $newResult[$key] = array_sum(array_map(function ($item) use ($key) {


                if ($item['date'] === $key) {
                    return $item['energy'];
                }
                return 0;
            }, $result));
            $current_time = strtotime(date('Y-m-d H:i:s', $current_time) . " $step");
        }
        $return = [];
        foreach ($newResult as $date => $energy) {
            $return[] = [
                'date' => $date,
                'energy' => $energy
            ];
        }
        success($return);

    }

}
