<?php

class sensors extends controller
{
    public function __construct()
    {
        parent::__construct();
        checkLogin();
    }

    public function sensors()
    {
        $addr = intval(input('addr'));
        $result = $this->device->getSensor($addr);
        success($result);
    }

    public function saveSensors()
    {
        $addr = intval(input('addr'));
        $data = (array)input('data');
        $this->device->setSensor($addr, $data);
        success([]);
    }

    public function controllers()
    {
        $addr = intval(input('addr'));
        $result = $this->device->getController($addr);
        success($result);
    }

    public function saveControllers()
    {
        $addr = intval(input('addr'));
        $data = (array)input('data');
        $this->device->setController($addr, $data);
        success([]);
    }

    public function linking()
    {
        $addr = intval(input('addr'));
        $linking = $this->device->getLinks($addr);
        success($linking);
    }

    public function saveLinking()
    {
        $sensor_no = input('sensor_no');
        $controller_no = input('controller_no');
        $enabled = input('enabled');
        if (!$controller_no || !$sensor_no) {
            error('参数错误');
        }

        $this->device->saveLinking(0,  $sensor_no, $controller_no, $enabled);
        success([]);
    }

    public function updateLinking()
    {
        $id = input('id');
        $sensor_no = input('sensor_no');
        $controller_no = input('controller_no');
        if (!$controller_no || !$sensor_no) {
            error('参数错误');
        }
        $enabled = input('enabled');
        $this->device->updateLinking(0, $id, $sensor_no, $controller_no, $enabled);
        success([]);
    }

    public function deleteLinking()
    {
        $id = (int)input('id');
        $addr = (int)input('id');
        $this->device->deleteLinking($addr,$id);
        success([]);

    }

}