<?php


class logs extends controller
{

    public function __construct()
    {
        parent::__construct();
        checkLogin();
    }

    public function alarms()
    {
        checkPermission('查看系统日志');
        $result = $this->db->query('select * from system_logs where read = 0 and type in (2,3,4,5,6,7,8,11)');

        $return = [
            'voltage' => 0,
            'current' => 0,
            'environment' => 0,
        ];

        foreach ($result as $item) {
            $content = json_decode($item['content'], true);
            switch ($item['type']) {
                case 1:
                    break;
                case 2:
                case 11:
                    $return['voltage']++;
                    break;
                case 3:
                case 4:
                case 5:
                case 8:
                    $return['current']++;
                    break;
                case 6:
                case 7:
                    $return['environment']++;
                    break;

            }
            // if ($item['type'] === 2) {
            //     switch ($content['warn']) {
            //         case 1:
            //         case 2:
            //             $return['voltage']++;
            //             break;
            //         case 3:
            //         case 4:
            //             $return['current']++;
            //             break;

            //     }
            // } else if ($item['type'] === 3) {
            //     $return['current']++;
            // } else if ($item['type'] == 5) {
            //     $return['environment']++;
            // }
        }
        success($return);
    }


    public function clearUser()
    {
        checkPermission("查看用户操作日志");
        $this->db->exec("delete from user_logs");
        success([]);
    }
    public function user()
    {
        checkPermission("查看用户操作日志");
        $datetime = (array)input('datetime');
        $where = "1 = 1 ";
        if (array_filter($datetime)) {
            $datetime[1] = date('Y-m-d H:i:s', strtotime($datetime[1]) + 3600 * 24 - 1);

            $datetime[0] = local2utc($datetime[0]);
            $datetime[1] = local2utc($datetime[1]);
            $where .= " and (user_logs.created_at between '{$datetime[0]}' and '{$datetime[1]}')";
        }

        $count = $this->db->count("select count(*) from user_logs where {$where}");
        if (input('all') == 1) {
            $result = $this->db->paginate("select user_logs.*,users.username from user_logs left join users on user_logs.user_id = users.id where {$where} order by id desc",$count);
        }else{
            $result = $this->db->paginate("select user_logs.*,users.username from user_logs left join users on user_logs.user_id = users.id where {$where} order by id desc");
        }
        foreach ($result as $key => $val) {
            // 端口操作使用 json 字符串保存
            if ($val['title'][0]== '{') 
            {
                $jsonData = json_decode($val['title']);
                $title = trans($jsonData->action);
                $title .= ',addr:' . strval($jsonData->addr);

                if ($GLOBALS['Flag']['is3PH'])
                {
                    $level = intdiv($jsonData->port, 4)%3+1;
                    if ((intdiv($jsonData->port, 12)+1)%2)
                    {
                        $title .= ',' . trans('端口') .' L' . strval($level) . '-' . strval($jsonData->port % 4 + 1);
                    }else
                    {
                        $title .= ',' . trans('端口') .' L' . strval($level) . '-' . strval($jsonData->port % 4+5);
                    }
                }else
                {
                    $title .= ',' . trans('端口') . strval($jsonData->port + 1);
                }

            }else
            {
                $lists = explode('【', $val['title']);
                $title = trans($lists[0]);
                if (isset($lists[1])) {
                    $title .= ('【.' . $lists[1]);
                }
            }
            
            $result[$key]['title'] = $title;
        }
        success($result, getMeta($count));
    }


    public function clearSystem()
    {
        checkPermission("查看系统日志");
        $this->db->exec("delete from system_logs");
        success([]);
    }

    public function system()
    {
        checkPermission("查看系统日志");
        $datetime = (array)input('datetime');
        $type = intval(input('type'));
        $read = input('read');
        $where = "1 = 1 ";
        if (array_filter($datetime)) {
            $datetime[0] = local2utc($datetime[0]);
            $datetime[1] = local2utc($datetime[1]);

            $datetime[1] = date('Y-m-d H:i:s', strtotime($datetime[1]) + 3600 * 24 - 1);
            $where .= "and (datetime between '{$datetime[0]}' and '{$datetime[1]}')";
        }
        if ($type && $type !== -1) {
            $where .= " and type = {$type}";
        }
        if ($read != null) {
            $read = intval($read);
            if ($read != -1) {
                $where .= " and read = {$read}";
            }
        }
        $count = $this->db->count("select count(*) from system_logs where {$where}");
        if (input('all') == 1) {
            $result = $this->db->paginate("select * from system_logs where {$where} order by id desc", $count);
        } else {
            $result = $this->db->paginate("select * from system_logs where {$where} order by id desc");
        }


        $typeList = ['未知', '通断电', '输入电压告警', '输入电流告警', '输出电流告警', '输出电流断电', '温度告警', '湿度告警', '输入电流断电', '传感器1警告', '传感器2警告'];
        $descList = ['未知', '通电', '断电', '低于下限', '高于上限'];

        $typeList = array_map(function ($item) {
            return trans($item);
        }, $typeList);

        $descList = array_map(function ($item) {
            return trans($item);
        }, $descList);

        foreach ($result as $k => $v) {
            $type = $v['type'];
            $content = json_decode($v['content'], true);
            $desc = Arr::get($content, 'desc', 0);
            $descStr = Arr::get($typeList, $type) . '：';
            if (isset($content['port'])) {
                // need process 3PH
                if ( $GLOBALS['Flag']['is3PH'])
                {
                    $port = intval($content['port']);
                    $level = intdiv($port, 4)%3+1;
                    if ((intdiv($port, 12)+1)%2)
                    {
                        $descStr .= trans('端口') .' L' . strval($level) . '-' . strval($port % 4 + 1);
                    }else
                    {
                        $descStr .= trans('端口') .' L' . strval($level) . '-' . strval($port % 4+5);
                    }
                }else
                {
                    $port = intval($content['port']) + 1;
                    $descStr .= trans('端口') . strval($port);
                }
            }
            $descStr .= ' ' . Arr::get($descList, $desc);

            $result[$k]['desc'] = $descStr;
        }

        success($result, getMeta($count));
    }

    public function readSystemLog()
    {
        checkPermission("查看系统日志");
        $id = (array)input('id');
        $idStr = implode(',', $id);
        $this->db->exec("update system_logs set read =1 where id in ({$idStr})");
        return success([]);
    }

}
