<?php

class email extends controller
{

    public function __construct()
    {
        parent::__construct();
        checkLogin();
    }

    public function index()
    {
        $result = $this->db->find("select * from email_settings");
        if (!$result) {
            $result = [
                'host' => null,
                'port' => null,
                'username' => null,
                'password' => null,
                'address' => null,
                'status' => 0,
            ];
        }
        success($result);
    }

    public function setting()
    {

        $data['host'] = input('host');
        $data['port'] = intval(input('port'));
        $data['username'] = input('username');
        $data['status'] = intval(input('status'));
        $data['address'] = $data['username'];
        $data['name'] = $data['username'];
        $data['password'] = input('password');

        if (!$data['host']) {
            error('服务器不正确');
        }
        if (!is_email($data['username'])) {
            error('用户名不正确');
        }

	if ($this->db->find("select * from email_settings")) {
            $this->db->exec("update email_settings set host = '{$data['host']}',port = '{$data['port']}',username = '{$data['username']}',password = '{$data['password']}',status = '{$data['status']}',address = '{$data['address']}'");
        } else {
            $this->db->exec("insert into email_settings (host,port,username,password,status,address) values('{$data['host']}','{$data['port']}','{$data['username']}','{$data['password']}','{$data['status']}','{$data['address']}')");
        }

        $this->writeLog("修改了邮件设置");
        success([]);
    }

    public function receivers()
    {
        $name = input('name');
        $email = input('email');

        $where = '1 = 1';
        if ($name) {
            $where .= " and name like '%{$name}%'";
        }
        if ($email) {
            $where .= " and email like '%{$email}%'";
        }
        $sql = "select * from email_receivers where {$where} order by id desc";

        $result = $this->db->query($sql);

        success($result);
    }


    public function saveReceiver()
    {
        $name = input('name');
        $email = input('email');
        $status = intval(input('status'));
        if (!$name || !$email) {
            error('数据输入错误');
        }

        if (!is_email($email)) {
            error('邮箱地址错误');
        };

        if ($this->db->find("select * from email_receivers where email = '{$email}'")) {
            error('邮箱地址已存在');
        }
        $this->db->exec("insert into email_receivers (name,email,status,created_at,updated_at) values('{$name}','{$email}',{$status},'{$this->datetime}','{$this->datetime}')");
        $this->writeLog("添加了邮箱接收人【{$email}】");
        success([]);
    }

    public function updateReceiver()
    {
        $id = intval(input('id'));
        $name = input('name');
        $email = input('email');
        $status = intval(input('status'));
        if (!$id || !$name || !$email) {
            error('数据输入错误');
        }

        if (!is_email($email)) {
            error('邮箱地址错误');
        };

        if ($this->db->find("select * from email_receivers where email = '{$email}' and id != {$id}")) {
            error('邮箱地址已存在');
        }
        $this->db->exec("update email_receivers set name = '{$name}' ,email = '{$email}',status = {$status} where id = {$id}");
        $this->writeLog("修改了邮箱接收人【{$email}】");
        success([]);
    }

    public function deleteReceiver()
    {
        $id = intval(input('id'));
        if (!$id) {
            error('参数错误');
        }
        $result = $this->db->find("select * from email_receivers where id = {$id}");
        if (!$result) {
            error('邮件接收人不存在');
        }
        $this->db->exec("delete from email_receivers where id = {$id}");
        $this->writeLog("删除了邮件接收人【{$result['name']}】");
        success([]);
    }


    public function records()
    {
        $addr = input('addr');
        $datetime = (array)input('datetime');
        $where = '1 = 1';
        if (!is_null($addr)) {
            $addr = intval($addr);
            $where .= " and addr = {$addr}";
        }
        if (array_filter($datetime)) {
            $datetime[0] = local2utc($datetime[0]);
            $datetime[1] = local2utc($datetime[1]);
            $datetime[1] = date('Y-m-d H:i:s', strtotime($datetime[1]) + 3600 * 24 - 1);
            $where .= " and (datetime between '{$datetime[0]}' and '{$datetime[1]}')";
        }

        $result = $this->db->query("select * from email_records where {$where} order by id desc");
        $count = $this->db->count("select count(*) from email_records where {$where}");

        foreach ($result as &$value) {
            $value['pdu'] = getPduName($value['addr']);
        }
        success($result, getMeta($count));

    }

    public function deleteRecords()
    {
        $id = (array)input("id");

        if (!$id) {
            error("参数错误");
        }
        $ids = implode(",", $id);
        $this->db->exec("delete from email_records where id in ({$ids})");
        $this->writeLog("删除了邮件发送记录【id:{$ids}}】");
        success([]);
    }

    public function test()
    {
        $host = input('host');
        $port = input('port');
        $username = input('username');
        $password = input('password');
        $email = input('email');
        $content = input('content');
        if (!$host || !$port || !$username || !$password || !$email || !$content) {
            error("参数错误");
        }
        $this->device->sendEmailTest($host, $port, $username, $password, $email, $content);
        success([]);
    }
}
