<?php


class alarms extends controller
{

    public function input()
    {
        $language = input('language');
        $addr = intval(input('addr'));
//        $result = $this->db->find("select * from alarms where addr = {$addr} and port is null ");
        $result = $this->device->getInputThresholds($addr,$language);
        success($result);
    }

    public function inputAll()
    {
        $devices = $this->device->getDeviceListSimple();
        $result = [];
        foreach ($devices as $device){
            $addr = $device['addr'];
            $info = $this->device->getInputThresholds($addr);
            $result[$addr] = $info;
        }
//        var_dump($devices);
//        $result = $this->db->query("select * from alarms where port is null ");
//        $return = [];
//        foreach ($result as $val) {
//            $return[$val['addr']] = $val;
//        }
         success($result);
    }

    public function updateInput()
    {
        checkPermission("输入告警设置");
        $addr = intval(input('addr'));
        $voltage_max = input('voltage_max');
        $voltage_min = input('voltage_min');
        $current_max = input('current_max');
        $current_min = input('current_min');

        $voltage_max === '' && $voltage_max = null;
        $voltage_min === '' && $voltage_min = null;
        $current_max === '' && $current_max = null;
        $current_min === '' && $current_min = null;
        if ((!is_null($voltage_max) && !is_numeric($voltage_max)) || $voltage_max < 0) {
            error('电压上限输入不正确');
        }
        if ((!is_null($voltage_min) && !is_numeric($voltage_min)) || $voltage_min < 0) {
            error('电压下限输入不正确');
        }
        if ((!is_null($current_max) && !is_numeric($current_max)) || $current_max < 0) {
            error('电流上限输入不正确');
        }
        if ((!is_null($current_min) && !is_numeric($current_min)) || $current_min < 0) {
            error('电流下限输入不正确');
        }

        $voltage_max = !is_null($voltage_max) ? doubleval($voltage_max) : 'null';
        $voltage_min = !is_null($voltage_min) ? doubleval($voltage_min) : 'null';
        $current_max = !is_null($current_max) ? doubleval($current_max) : 'null';
        $current_min = !is_null($current_min) ? doubleval($current_min) : 'null';
//        if ($this->db->count("select count(*) from alarms where addr = {$addr} and port is null")) {
//            $this->db->exec("update alarms set voltage_max = {$voltage_max},voltage_min = {$voltage_min},current_max = {$current_max},current_min = {$current_min} where addr = {$addr} and port is null");
//        } else {
//            $this->db->exec("insert into alarms (addr,voltage_max,voltage_min,current_max,current_min) values({$addr},{$voltage_max},{$voltage_min},{$current_max},{$current_min})");
//        }
        $this->device->updateInputThreshold($addr, $current_max, $current_min, $voltage_max, $voltage_min, null, null);
        $this->writeLog("修改了输入告警设置【addr:{$addr}】");
        success([]);
    }

    public function updateInputOff()
    {
        checkPermission("输入断电设置");
        $addr = intval(input('addr'));
        $off_current_max = input('off_current_max');
        $off_current_min = input('off_current_min');

        $off_current_max === '' && $off_current_max = null;
        $off_current_min === '' && $off_current_min = null;

        if ((!is_null($off_current_max) && !is_numeric($off_current_max)) || $off_current_max < 0) {
            error('电流上限输入不正确');
        }
        if ((!is_null($off_current_min) && !is_numeric($off_current_min)) || $off_current_min < 0) {
            error('电流下限输入不正确');
        }

        $off_current_max = !is_null($off_current_max) ? doubleval($off_current_max) : 'null';
        $off_current_min = !is_null($off_current_min) ? doubleval($off_current_min) : 'null';
//        if ($this->db->count("select count(*) from alarms where addr = {$addr} and port is null")) {
//            $this->db->exec("update alarms set off_current_max = {$off_current_max},off_current_min = {$off_current_min} where addr = {$addr} and port is null");
//        } else {
//            $this->db->exec("insert into alarms (addr,off_current_max,off_current_min) values({$addr},{$off_current_max},{$off_current_min})");
//        }
        $this->device->updateInputThreshold($addr, null, null, null, null, $off_current_max, $off_current_min);
        $this->writeLog("修改了输入告警设置【addr:{$addr}】");
        success([]);
    }

    public function updateHumiture()
    {
        checkPermission("温湿度告警设置");
        $addr = intval(input('addr'));
        $temperature_max = input('temperature_max');
        $temperature_min = input('temperature_min');
        $humidity_max = input('humidity_max');
        $humidity_min = input('humidity_min');

        $temperature_max === '' && $temperature_max = null;
        $temperature_min === '' && $temperature_min = null;
        $humidity_max === '' && $humidity_max = null;
        $humidity_min === '' && $humidity_min = null;
        if ((!is_null($temperature_max) && !is_numeric($temperature_max))) {
            error('温度上限输入不正确');
        }
        if ((!is_null($temperature_min) && !is_numeric($temperature_min))) {
            error('温度下限输入不正确');
        }
        if ((!is_null($humidity_max) && !is_numeric($humidity_max)) || $humidity_max < 0 || $humidity_min > 100) {
            error('湿度上限输入不正确');
        }
        if ((!is_null($humidity_min) && !is_numeric($humidity_min)) || $humidity_min < 0 || $humidity_min > 100) {
            error('湿度下限输入不正确');
        }

        $temperature_max = !is_null($temperature_max) ? doubleval($temperature_max) : 'null';
        $temperature_min = !is_null($temperature_min) ? doubleval($temperature_min) : 'null';
        $humidity_max = !is_null($humidity_max) ? doubleval($humidity_max) : 'null';
        $humidity_min = !is_null($humidity_min) ? doubleval($humidity_min) : 'null';
//        if ($this->db->count("select count(*) from alarms where addr = {$addr} and port is null")) {
//            $this->db->exec("update alarms set temperature_max = {$temperature_max},temperature_min = {$temperature_min},humidity_max = {$humidity_max},humidity_min = {$humidity_min} where addr = {$addr} and port is null");
//        } else {
//            $this->db->exec("insert into alarms (addr,temperature_max,temperature_min,humidity_max,humidity_min) values({$addr},{$temperature_max},{$temperature_min},{$humidity_max},{$humidity_min})");
//        }
        $this->device->updateHumitureThreshold($addr, $temperature_max, $temperature_min, $humidity_max, $humidity_min);
        $this->writeLog("修改了温湿度告警设置【addr:{$addr}】");
        success([]);
    }

    public function out()
    {
        checkPermission("输出告警设置");
        $addr = intval(input('addr'));
//        $result = $this->db->query("select * from alarms where addr = {$addr} and port is not null");
        $result = $this->device->getOutputThresholds($addr);
        success($result);

    }

    public function humiture()
    {
        checkPermission("输出告警设置");
        $addr = intval(input('addr'));
//        $result = $this->db->query("select * from alarms where addr = {$addr} and port is not null");
        $result = $this->device->getHumitureThresholds($addr);
        success($result);

    }
    public function updateOut()
    {
        checkPermission("输出告警设置");
        $addr = intval(input('addr'));
        $ports = (array)(input('ports'));

        $ports = array_map(function ($item) {
            $item['port'] = intval($item['port']);
            if ($item['current_max'] === '') {
                $item['current_max'] = null;
            }
            if ((!is_null($item['current_max']) && !is_numeric($item['current_max'])) || $item['current_max'] < 0) {
                error('电流上限输入不正确');
            }
            $item['current_max'] = !is_null($item['current_max']) ? $item['current_max'] : 'null';

            if ($item['current_min'] === '') {
                $item['current_min'] = null;
            }
            if ((!is_null($item['current_min']) && !is_numeric($item['current_min'])) || $item['current_min'] < 0) {
                error('电流下限输入不正确');
            }
            $item['current_min'] = !is_null($item['current_min']) ? $item['current_min'] : 'null';
            return $item;
        }, $ports);

        $sql = "";

//        foreach ($ports as $port) {
//            if ($this->db->count("select count(*) from alarms where addr = {$addr} and port = {$port['port']}")) {
//                $sql .= "update alarms set current_max = {$port['current_max']},current_min = {$port['current_min']} where addr = {$addr} and port = {$port['port']}; \n";
//            } else {
//                $sql .= "insert into alarms (addr,port,current_max,current_min) values({$addr},{$port['port']},{$port['current_max']},{$port['current_min']}); \n";
//            }
//
//        }
//        $this->db->exec($sql);
        $this->device->updateOutThreshold($addr, (array)input('ports'));
        $this->writeLog("修改了输出告警设置【addr:{$addr}】");

        success([]);
    }


    public function outage()
    {
        checkPermission("输出断电设置");
        $addr = intval(input('addr'));
        $ports = (array)(input('ports'));

        $ports = array_map(function ($item) {
            $item['port'] = intval($item['port']);
            if ($item['outage_max'] === '') {
                $item['outage_max'] = null;
            }
            if ((!is_null($item['outage_max']) && !is_numeric($item['outage_max'])) || $item['outage_max'] < 0) {
                error('断电电流上限输入不正确');
            }
            $item['outage_max'] = !is_null($item['outage_max']) ? $item['outage_max'] : 'null';

            if ($item['outage_min'] === '') {
                $item['outage_min'] = null;
            }
            if ((!is_null($item['outage_min']) && !is_numeric($item['outage_min'])) || $item['outage_min'] < 0) {
                error('断电电流下限输入不正确');
            }
            $item['outage_min'] = !is_null($item['outage_min']) ? $item['outage_min'] : 'null';
            return $item;
        }, $ports);

        $sql = "";

//        foreach ($ports as $port) {
//            if ($this->db->count("select count(*) from alarms where addr = {$addr} and port = {$port['port']}")) {
//                $sql .= "update alarms set outage_max = {$port['outage_max']},outage_min = {$port['outage_min']} where addr = {$addr} and port = {$port['port']}; \n";
//            } else {
//                $sql .= "insert into alarms (addr,port,outage_max,outage_min) values({$addr},{$port['port']},{$port['outage_max']},{$port['outage_min']}); \n";
//            }
//
//        }
//        $this->db->exec($sql);
        $this->device->updateOutThreshold($addr, (array)input('ports'));
        $this->writeLog("修改了电流断电设置【addr:{$addr}】");

        success([]);
    }


    public function updateBat()
    {
        checkPermission("输出告警设置");
        checkPermission("输出断电设置");
        $addr = intval(input('addr'));
        $ports = (array)input('ports');
        $input = input();

        if (!$ports) {
            error('请选择端口');
        }
        $data = [];

        $sqlAll = '';
        foreach ($ports as $port) {
            unset($current_max, $current_min, $outage_max, $outage_min, $sqlValue);
            $item = [
                'port' => $port
            ];
            if (isset($input['current_max'])) {
                $current_max = $input['current_max'];
                if ((!is_null($current_max) && !is_numeric($current_max) || $current_max < 0)) {
                    error('电流上限输入不正确');
                }
                $item['current_max'] = $current_max;
                if ($current_max === '' || is_null($current_max)) {
                    $current_max = 'null';
                }
            }
            if (isset($input['current_min'])) {
                $current_min = $input['current_min'];
                if ((!is_null($current_min) && !is_numeric($current_min) || $current_min < 0)) {
                    error('电流下限输入不正确');
                }
                $item['current_min'] = $current_min;
                if ($current_min === '' || is_null($current_min)) {
                    $current_min = 'null';
                }
            }
            if (isset($input['outage_max'])) {
                $outage_max = $input['outage_max'];
                if ((!is_null($outage_max) && !is_numeric($outage_max) || $outage_max < 0)) {
                    error('断电电流上限输入不正确');
                }
                $item['outage_max'] = $outage_max;
                if ($outage_max === '' || is_null($outage_max)) {
                    $outage_max = 'null';
                }
            }
            if (isset($input['outage_min'])) {
                $outage_min = $input['outage_min'];
                if ((!is_null($outage_min) && !is_numeric($outage_min) || $outage_min < 0)) {
                    error('断电电流下限输入不正确');
                }
                $item['outage_min'] = $outage_min;
                if ($outage_min === '' || is_null($outage_min)) {
                    $outage_min = 'null';
                }
            }
            $data[] = $item;

            $sqlValue = "";
            if (isset($current_max)) {
                $sqlValue .= "current_max = {$current_max},";
            }
            if (isset($current_min)) {
                $sqlValue .= "current_min = {$current_min},";
            }
            if (isset($outage_max)) {
                $sqlValue .= "outage_max = {$outage_max},";
            }
            if (isset($outage_min)) {
                $sqlValue .= "outage_min = {$outage_min},";
            }
            $sqlValue = trim($sqlValue, ",");
            if ($sqlValue) {
                if ($this->db->count("select count(*) from alarms where addr = {$addr} and port = {$port}")) {
                    $sql = "update alarms set {$sqlValue} where addr = {$addr} and port = {$port}";
                } else {
                    $sql = "insert into alarms set addr = {$addr},port = {$port} ,{$sqlValue}";
                }
                $sqlAll .= $sql . ";\n";
            }
        }

//        if ($sqlAll) {
//          $this->db->exec($sqlAll);
//            $this->writeLog("批量修改了输出阈值设置【addr:{$addr}】");
//        }

        $this->writeLog("批量修改了输出阈值设置【addr:{$addr}】");
        $this->device->updateOutThreshold($addr, $data);
        success($data);

    }


}
